//***********************************************
//*		NeoSaber's Renegade Scripts Source File	*
//***********************************************

#include "scripts.h"
#include "neo.h"

//**************Script Functions*****************

//*********Neo_CreateObject_RandomTimer**********

void Neo_CreateObject_RandomTimer::Created(GameObject *obj)
{
	//Start Counting
	float timer;
	timer = Commands->Get_Random(Get_Float_Parameter("Min"),Get_Float_Parameter("Max"));
	Commands->Start_Timer(obj, this, timer, 0);
}

void Neo_CreateObject_RandomTimer::Timer_Expired(GameObject *obj, int number)
{
	//Time's up, create the object

	GameObject *newobj;

	newobj = Commands->Create_Object(Get_Parameter("Preset_Name"),Commands->Get_Position(obj));
	Commands->Set_Facing(newobj, Commands->Get_Facing(obj));

	int repeat = Get_Int_Parameter("Repeat");

	if(repeat == 1) //Check if we should start again
	{
		//Start Counting again
		float timer;
		timer = Commands->Get_Random(Get_Float_Parameter("Min"),Get_Float_Parameter("Max"));
		Commands->Start_Timer(obj, this, timer, 0);
	}
}

//**************Script Registrants***************

ScriptRegistrant<Neo_CreateObject_RandomTimer> Neo_CreateObject_RandomTimer_Registrant("Neo_CreateObject_RandomTimer", "Preset_Name=blank:string,Min=0.0:float,Max=60.0:float,Repeat=1:int");
